/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import cz.insophy.inplan.export.TableWriter;
import cz.insophy.inplan.export.excel.ExcelTableWriter;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.property.Propertized;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.ExporterUtils;
import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.Tuple;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SuperplanExcelExporter {
    public void export(Superplan superplan, ExcelTableWriter writer) {
        this.export(superplan, Long.MIN_VALUE, superplan.getFixationDate(), true, writer);
    }

    public void export(Superplan superplan, long from, long to, TableWriter writer) {
        this.export(superplan, from, to, false, writer);
    }

    private void export(Superplan superplan, long from, long to, boolean fixationOnly, TableWriter writer) {
        this.writeGorSheet(superplan, fixationOnly, writer);
        this.writePlanSheet(superplan, from, to, fixationOnly, writer);
        this.writeScheduleSheet(superplan, from, to, writer);
    }

    private void writeGorSheet(Superplan superplan, boolean fixationOnly, TableWriter writer) {
        writer.newSheet(Localizer.getString("xls_export.orders"));
        Collection<PropertyDefinition> pdefs = superplan.getShopConf().getPropertyDefinitionsFor(GeneralizedOrderRequest.class);
        writer.newRow();
        writer.newHeaderCell(Localizer.getString("xls_export.id"));
        writer.newHeaderCell(Localizer.getString("xls_export.product"));
        writer.newHeaderCell(Localizer.getString("xls_export.description"));
        writer.newHeaderCell(Localizer.getString("xls_export.state"));
        writer.newHeaderCell(Localizer.getString("xls_export.priority"));
        writer.newHeaderCell(Localizer.getString("xls_export.alternative"));
        writer.newHeaderCell(Localizer.getString("xls_export.start"));
        writer.newHeaderCell(Localizer.getString("xls_export.end"));
        writer.newHeaderCell(Localizer.getString("xls_export.release"));
        writer.newHeaderCell(Localizer.getString("xls_export.due"));
        writer.newHeaderCell(Localizer.getString("xls_export.netto_manuf_time"));
        writer.newHeaderCell(Localizer.getString("xls_export.qty"));
        writer.newHeaderCell(Localizer.getString("xls_export.planned_ratio"));
        writer.newHeaderCell(Localizer.getString("xls_export.fixed"));
        this.writePropertyHeaders(writer, pdefs);
        List<GeneralizedOrderRequest> gors = ExporterUtils.gorsForExport(superplan, superplan.getGors(), fixationOnly, true);
        for (GeneralizedOrderRequest gor : gors) {
            writer.newRow();
            writer.newStringCell(gor.getId(), null);
            writer.newStringCell(gor.getProduct().getName(), null);
            writer.newStringCell(gor.getDescription(), null);
            writer.newStringCell(gor.getState().getLabel(), null);
            writer.newIntegerCell(Long.valueOf(gor.getPriority()), null);
            writer.newStringCell(this.safeGetName(gor.getSelectedActiongram()), null);
            writer.newDatetimeCell(gor.getStartDate(), null);
            writer.newDatetimeCell(gor.getEndDate(), null);
            writer.newDatetimeCell(gor.getReleaseDate(), null);
            writer.newDatetimeCell(gor.getDueDate(), null);
            writer.newDurationInHourCell(gor.getPlannedDuration() / 1000L / 3600L, null);
            writer.newFloatCell(gor.getRequestedQty(), null);
            writer.newPercentCell(gor.getPlannedRatio(), null);
            writer.newBooleanCell(this.safeIsFixed(gor.getStartDate(), superplan.getFixationDate()), null);
            this.writerPropertyValues(writer, pdefs, gor);
        }
    }

    private void writePlanSheet(Superplan superplan, long from, long to, boolean fixationOnly, TableWriter writer) {
        writer.newSheet(Localizer.getString("xls_export.manuf_plan"));
        Collection<PropertyDefinition> pdefs = superplan.getShopConf().getPropertyDefinitionsFor(GeneralizedOrderRequest.class);
        writer.newRow();
        writer.newHeaderCell(Localizer.getString("xls_export.id"));
        writer.newHeaderCell(Localizer.getString("xls_export.product"));
        writer.newHeaderCell(Localizer.getString("xls_export.description"));
        writer.newHeaderCell(Localizer.getString("xls_export.state"));
        writer.newHeaderCell(Localizer.getString("xls_export.priority"));
        writer.newHeaderCell(Localizer.getString("xls_export.alternative"));
        writer.newHeaderCell(Localizer.getString("xls_export.operation_no"));
        writer.newHeaderCell(Localizer.getString("xls_export.operation_step"));
        writer.newHeaderCell(Localizer.getString("xls_export.work_center"));
        writer.newHeaderCell(Localizer.getString("xls_export.qty"));
        writer.newHeaderCell(Localizer.getString("xls_export.setup_time"));
        writer.newHeaderCell(Localizer.getString("xls_export.brutto_manuf_time"));
        writer.newHeaderCell(Localizer.getString("xls_export.netto_manuf_time"));
        writer.newHeaderCell(Localizer.getString("xls_export.brutto_start"));
        writer.newHeaderCell(Localizer.getString("xls_export.netto_start"));
        writer.newHeaderCell(Localizer.getString("xls_export.end"));
        writer.newHeaderCell(Localizer.getString("xls_export.fixed"));
        writer.newHeaderCell(Localizer.getString("xls_export.gor_rd"));
        writer.newHeaderCell(Localizer.getString("xls_export.gor_dd"));
        this.writePropertyHeaders(writer, pdefs);
        List<GeneralizedOrderRequest> gors = ExporterUtils.gorsForExport(superplan, superplan.getGors(), fixationOnly, true);
        for (GeneralizedOrderRequest gor : gors) {
            long gorStart = gor.getStartDate();
            long gorEnd = gor.getEndDate();
            if (!fixationOnly && (GeneralizedRequest.isDateValid(gorEnd) && gorEnd <= from || GeneralizedRequest.isDateValid(gorStart) && gorStart >= to)) continue;
            for (GeneralizedActionRequest gar : gor.getGars()) {
                int step = 1;
                for (ActionActivity aa : gar.getActivities()) {
                    Tuple<Long, Long> aaContext = ExporterUtils.computeRebuildTime(superplan.getPlan(), aa);
                    long totalSetupTime = aaContext.getFirst();
                    long firstRebuildStart = aaContext.getSecond();
                    writer.newRow();
                    writer.newStringCell(gor.getId(), null);
                    writer.newStringCell(gor.getProduct().getName(), null);
                    writer.newStringCell(gor.getDescription(), null);
                    writer.newStringCell(gor.getState().getLabel(), null);
                    writer.newIntegerCell(Long.valueOf(gor.getPriority()), null);
                    writer.newStringCell(this.safeGetName(gor.getSelectedActiongram()), null);
                    writer.newStringCell(gar.getAction().getName(), null);
                    writer.newIntegerCell(Long.valueOf(step++), null);
                    writer.newStringCell(aa.getWorkplace().getName(), null);
                    writer.newFloatCell(aa.getQty(), null);
                    writer.newFloatCell((double)totalSetupTime / 1000.0 / 3600.0, null);
                    writer.newFloatCell((double)(aa.getDuration() + totalSetupTime) / 1000.0 / 3600.0, null);
                    writer.newFloatCell((double)aa.getDuration() / 1000.0 / 3600.0, null);
                    writer.newDatetimeCell(firstRebuildStart, null);
                    writer.newDatetimeCell(aa.getStart(), null);
                    writer.newDatetimeCell(aa.getEnd(), null);
                    writer.newBooleanCell(this.safeIsFixed(aa.getStart(), superplan.getFixationDate()), null);
                    writer.newDatetimeCell(gor.getReleaseDate(), null);
                    writer.newDatetimeCell(gor.getDueDate(), null);
                    this.writerPropertyValues(writer, pdefs, gor);
                }
            }
        }
    }

    private void writeScheduleSheet(Superplan superplan, long from, long to, TableWriter writer) {
        writer.newSheet(Localizer.getString("xls_export.work_queues"));
        Collection<PropertyDefinition> pdefs = superplan.getShopConf().getPropertyDefinitionsFor(GeneralizedOrderRequest.class);
        writer.newRow();
        writer.newHeaderCell(Localizer.getString("xls_export.work_center"));
        writer.newHeaderCell(Localizer.getString("xls_export.start"));
        writer.newHeaderCell(Localizer.getString("xls_export.end"));
        writer.newHeaderCell(Localizer.getString("xls_export.type"));
        writer.newHeaderCell(Localizer.getString("xls_export.id"));
        writer.newHeaderCell(Localizer.getString("xls_export.product"));
        writer.newHeaderCell(Localizer.getString("xls_export.alternative"));
        writer.newHeaderCell(Localizer.getString("xls_export.operation_no"));
        writer.newHeaderCell(Localizer.getString("xls_export.qty"));
        writer.newHeaderCell(Localizer.getString("xls_export.action_type"));
        writer.newHeaderCell(Localizer.getString("xls_export.rebuild_to"));
        writer.newHeaderCell(Localizer.getString("xls_export.fixed"));
        writer.newHeaderCell(Localizer.getString("xls_export.gor_rd"));
        writer.newHeaderCell(Localizer.getString("xls_export.gor_dd"));
        this.writePropertyHeaders(writer, pdefs);
        for (WorkplaceSchedule wps : superplan.getPlan().getWorkplaceSchedules()) {
            WorkplaceActivity wa;
            Iterator<WorkplaceActivity> wai = wps.forwardIterator(from, true);
            while (wai.hasNext() && (wa = wai.next()).getStart() < to) {
                if (wa instanceof OfflineActivity && !((OfflineActivity)wa).hasNote()) continue;
                if (wa instanceof ActionActivity) {
                    this.writeScheduleRow((ActionActivity)wa, superplan.getFixationDate(), pdefs, writer);
                    continue;
                }
                if (wa instanceof CumulativeWorkplaceActivity) {
                    this.writeScheduleRow((CumulativeWorkplaceActivity)wa, superplan.getFixationDate(), pdefs, writer);
                    continue;
                }
                if (wa instanceof RebuildActivity) {
                    this.writeScheduleRow((RebuildActivity)wa, superplan.getFixationDate(), writer);
                    continue;
                }
                if (!(wa instanceof OfflineActivity)) continue;
                this.writeScheduleRow((OfflineActivity)wa, superplan.getFixationDate(), writer);
            }
        }
    }

    private void writeScheduleRow(ActionActivity aa, long fixationDate, Iterable<PropertyDefinition> pdefs, TableWriter writer) {
        GeneralizedActionRequest gar = aa.getGar();
        GeneralizedOrderRequest gor = (GeneralizedOrderRequest)gar.getParent();
        writer.newRow();
        writer.newStringCell(aa.getWorkplace().getName(), null);
        writer.newDatetimeCell(aa.getStart(), null);
        writer.newDatetimeCell(aa.getEnd(), null);
        writer.newStringCell(Localizer.getString("xls_export.type.ActionActivity"), null);
        writer.newStringCell(gor.getId(), null);
        writer.newStringCell(gor.getProduct().getName(), null);
        writer.newStringCell(this.safeGetName(gor.getSelectedActiongram()), null);
        writer.newStringCell(gar.getAction().getName(), null);
        writer.newFloatCell(aa.getQty(), null);
        writer.newStringCell(gar.getAction().getRebuildType(), null);
        writer.newEmptyCell(null);
        writer.newBooleanCell(this.safeIsFixed(aa.getStart(), fixationDate), null);
        writer.newDatetimeCell(gor.getReleaseDate(), null);
        writer.newDatetimeCell(gor.getDueDate(), null);
        this.writerPropertyValues(writer, pdefs, gor);
    }

    private void writeScheduleRow(CumulativeWorkplaceActivity cwa, long fixationDate, Iterable<PropertyDefinition> pdefs, TableWriter writer) {
        writer.newRow();
        writer.newStringCell(cwa.getWorkplace().getName(), null);
        writer.newDatetimeCell(cwa.getStart(), null);
        writer.newDatetimeCell(cwa.getEnd(), null);
        writer.newStringCell(String.format("%s (%d):", Localizer.getString("xls_export.type.CumulativeWorkplaceActivity"), cwa.getActionActivities().size()), null);
        writer.newEmptyCell(null);
        writer.newEmptyCell(null);
        writer.newEmptyCell(null);
        writer.newEmptyCell(null);
        writer.newEmptyCell(null);
        writer.newStringCell(cwa.getCumulationType(), null);
        writer.newEmptyCell(null);
        writer.newBooleanCell(this.safeIsFixed(cwa.getStart(), fixationDate), null);
        for (ActionActivity aa : cwa.getActionActivities()) {
            this.writeScheduleRow(aa, fixationDate, pdefs, writer);
        }
    }

    private void writeScheduleRow(RebuildActivity ra, long fixationDate, TableWriter writer) {
        writer.newRow();
        writer.newStringCell(ra.getWorkplace().getName(), null);
        writer.newDatetimeCell(ra.getStart(), null);
        writer.newDatetimeCell(ra.getEnd(), null);
        this.writeScheduleCells(ra, fixationDate, writer);
    }

    private void writeScheduleRow(OfflineActivity oa, long fixationDate, TableWriter writer) {
        writer.newRow();
        writer.newStringCell(oa.getWorkplace().getName(), null);
        writer.newDatetimeCell(oa.getStart(), null);
        writer.newDatetimeCell(oa.getEnd(), null);
        this.writeScheduleCells(oa, fixationDate, writer);
    }

    private void writeScheduleCells(RebuildActivity ra, long fixationDate, TableWriter writer) {
        writer.newStringCell(Localizer.getString("xls_export.type.RebuildActivity"), null);
        writer.newEmptyCell(null);
        writer.newEmptyCell(null);
        writer.newEmptyCell(null);
        writer.newEmptyCell(null);
        writer.newEmptyCell(null);
        writer.newEmptyCell(null);
        writer.newStringCell(ra.getTo(), null);
        writer.newBooleanCell(this.safeIsFixed(ra.getStart(), fixationDate), null);
    }

    private void writeScheduleCells(OfflineActivity oa, long fixationDate, TableWriter writer) {
        writer.newStringCell(Localizer.getString("xls_export.type.OfflineActivity"), null);
        writer.newStringCell(oa.getNote(), null);
        writer.newEmptyCell(null);
        writer.newEmptyCell(null);
        writer.newEmptyCell(null);
        writer.newEmptyCell(null);
        writer.newEmptyCell(null);
        writer.newEmptyCell(null);
        writer.newBooleanCell(this.safeIsFixed(oa.getStart(), fixationDate), null);
    }

    private void writePropertyHeaders(TableWriter writer, Iterable<PropertyDefinition> pdefs) {
        for (PropertyDefinition pdef : pdefs) {
            writer.newHeaderCell(pdef.getLabel());
        }
    }

    private void writerPropertyValues(TableWriter writer, Iterable<PropertyDefinition> pdefs, Propertized entity) {
        block8: for (PropertyDefinition pd : pdefs) {
            Object value = entity.getProperty(pd);
            if (value == null) {
                writer.newEmptyCell(null);
                continue;
            }
            switch (pd.getType()) {
                case BOOLEAN: {
                    writer.newBooleanCell((Boolean)value, null);
                    continue block8;
                }
                case DATETIME: {
                    writer.newDatetimeCell((Long)value, null);
                    continue block8;
                }
                case DOUBLE: {
                    writer.newFloatCell((Double)value, null);
                    continue block8;
                }
                case LONG: {
                    writer.newIntegerCell((Long)value, null);
                    continue block8;
                }
                case STRING: {
                    writer.newStringCell((String)value, null);
                    continue block8;
                }
                case DURATION: {
                    writer.newDurationInHourCell((Long)value, null);
                    continue block8;
                }
            }
            writer.newStringCell(value.toString(), null);
        }
    }

    private boolean safeIsFixed(Long date, Long fixationDate) {
        if (date == null || fixationDate == null) {
            return false;
        }
        return GeneralizedRequest.isDateValid(date) && GeneralizedRequest.isDateValid(fixationDate);
    }

    private String safeGetName(Actiongram actiongram) {
        if (actiongram == null) {
            return null;
        }
        return actiongram.getName();
    }
}

